library(sjstats)
library(groupedstats)
library(lsr)
library(ggplot2)

db = file.choose()

dat <- read.csv(file = db, header = T, sep = ",")
dat$subID <- as.factor(dat$subID)

fig <- grouped_summary(data = dat, grouping.vars = list(condition), measures = dat, measures.type = "numeric")
fig

Patient <- "darkorchid" 
Actor <-  "black"

data_summary <- function(x) {
  mu <- mean(x)
  sigma1 <- mu-sd(x)
  sigma2 <- mu+sd(x)
  return(c(y=mu,ymin=sigma1,ymax=sigma2))
}


dat$condition <- factor(dat$condition, level = c("Patient","Actor"))

ggplot(dat,aes(x=factor(condition),y=dat, colour = factor(condition))) +  
  scale_y_continuous(name="Amplitude (V)",limits=c(-2,2), breaks=seq(-2,2,2), expand = c(0,0)) + 
  geom_violin(alpha=0.1, scale = "width", width = 0.6, position=position_dodge(0.7), names=c("Patient","Actor/Actress"),
              aes(fill = condition,group = condition)) + 
  scale_fill_manual(values = c(Patient,Actor)) +  
  scale_colour_manual(values = c(Patient,Actor)) + 
  geom_point(size = 1, shape = 16, position=position_jitterdodge(jitter.width = 0.4,dodge.width = 0.7),
             aes(group = condition))+ 

  stat_summary(fun.data = data_summary,aes(group = condition),position=position_dodge(0.7), size = 1, shape = 19) +  ### to add the bar
  stat_summary(fun.data = data_summary,aes(group = condition),geom = "line",colour = "black", size = 1, position=position_dodge(0.7)) + 
  xlab(NULL) +
  theme(text=element_text(family = "Time New Roman"),
        panel.background = element_rect(fill = "transparent"), 
        axis.line.y = element_line(size = 1, colour = "black"), 
        axis.ticks.x = element_line(size = 1, colour = "white"), 
        axis.ticks.y = element_line(size = 1, colour = "black"), 
        axis.title.y=element_text(color="Black", size=15, face="bold"),
        axis.ticks.length=unit(-0.25, "cm"), 
        axis.text.x = element_text(margin=unit(c(0.5,0.5,0.5,0.5), "cm")), 
        axis.text.y = element_text(margin=unit(c(0.5,0.5,0.5,0.5), "cm")),
        axis.text=element_text(colour = "black",size=15,face = "bold"), 
        axis.title.x=element_text(color="Black", size=15, face="bold"), 
        legend.title = element_blank())+
  geom_hline(aes(yintercept=0), linetype=2,size = 1)
